#pragma rtGlobals=2		// Use modern global access method.
//#include "justfilters"
#include "mafutils", menus=0
#include "mafITC"

menu "Acquisition"
	"Show Scope Window", /Q, initmafscope()
	"Show New Scope Window", /Q, initnewmafscope()
	"-"
end

function initmafscope ()
	mafITC_init()

	if (exists ("root:maf:mafScopeGain0") == 0)
		String savedDataFolder = GetDataFolder(1)
		SetDataFolder root:maf
		variable /g mafScopeGain0 = 1, mafScopeGain1 = 1
		variable /g mafScopePulseDrtn = 2, mafScopeSweepDrtn = .005, mafScopeLastSweepDrtn=-1
		variable /g mafScopeRAvgNum=3, mafScopeRAvgIndex=0
		make /o/n=(mafScopeRAvgNum) mafScopeRAvg0, mafScopeRAvg1
		string /g mafScopeRStr0, mafScopeRStr1
		variable /g mafScopeGoing = 0
		string /g mafScopeClip = ""
		variable /g mafScopePulseAmpVC0=-5, mafScopePulseAmpCC0=-5, mafScopePulseAmpVC1=-5, mafScopePulseAmpCC1=-.01
		variable /g mafScopeStoreCount = 0, mafScopeSweepInterval =0
		variable /g mafScopeCh0On, mafScopeCh1On
		mafScopeLoadSettings ()
		
		make /o/n=512 mafScopeStimWave0, mafScopeWave0, mafScopeStimWave1, mafScopeWave1, mafScopeStimWaveD, mafScopeWaveD
		SetScale/I x 0,mafScopeSweepDrtn, "s", mafScopeStimWave0, mafScopeWave0, mafScopeStimWave1, mafScopeWave1, mafScopeStimWaveD, mafScopeWaveD
		make /o/n=2 mafScopeStimIndicator; mafScopeStimIndicator = 0
		SetScale/I x mafscopesweepdrtn *.1, mafscopesweepdrtn * .1 + mafscopepulsedrtn/1000,"s", mafScopeStimIndicator
		mafScopeWave0 = nan
		mafScopeWave1 = nan
		setdatafolder savedDataFolder
	endif
	dowindow /f mafScope
	if (v_flag == 0)
		execute "mafscope ()"
		mafscopeCCCheckProc (selectstring (mafITC_IsCC(0), "VCCheck_0", "CCCheck_0"), 1)
		mafscopeCCCheckProc (selectstring (mafITC_IsCC(1), "VCCheck_1", "CCCheck_1"), 1)
		ChCheckProc("",0)
		gridcheckproc ("", checkval ("GridCheck", "mafScope"))
	endif
end

function mafScopeLoadSettings ()
	variable sfile	// file to hold settings
	variable tempval
	
	open /t="IGBW"/z/r/p=Igor sfile as "mafScope5 Settings"
	if (v_flag == 0)	// i.e. file exists
		String savedDataFolder = GetDataFolder(1)
		SetDataFolder root:maf
		fbinread sfile, mafScopePulseAmpVC0
		fbinread sfile, mafScopePulseAmpCC0
		fbinread sfile, mafScopePulseAmpVC1
		fbinread sfile, mafScopePulseAmpCC1
		fbinread sfile, mafScopeSweepDrtn
		fbinread sfile, mafScopePulseDrtn
		fbinread sfile, mafScopeGain0
		fbinread sfile, mafScopeGain1
		fbinread sfile, mafScopeCh0On
		fbinread sfile, mafScopeCh1On
		fbinread sfile, tempval; mafITC_SetClamp (0, tempval)
		fbinread sfile, tempval; mafITC_SetClamp (1, tempval)
		setdatafolder savedDataFolder
	endif
	close sfile
	controlupdate /a
end

function mafScopeSaveSettings (ctrlName) : ButtonControl
	string ctrlName
	variable sfile	// file to hold settings
	variable tempval
	
	open /t="IGBW"/p=Igor sfile as "mafScope5 Settings"
	fbinwrite sfile, root:maf:mafScopePulseAmpVC0
	fbinwrite sfile, root:maf:mafScopePulseAmpCC0
	fbinwrite sfile, root:maf:mafScopePulseAmpVC1
	fbinwrite sfile, root:maf:mafScopePulseAmpCC1
	fbinwrite sfile, root:maf:mafScopeSweepDrtn
	fbinwrite sfile, root:maf:mafScopePulseDrtn
	fbinwrite sfile, root:maf:mafScopeGain0
	fbinwrite sfile, root:maf:mafScopeGain1
	fbinwrite sfile, root:maf:mafScopeCh0On
	fbinwrite sfile, root:maf:mafScopeCh1On
	tempval = mafITC_isCC(0); fbinwrite sfile, tempval
	tempval = mafITC_isCC(1); fbinwrite sfile, tempval
	close sfile
end

function mafScopeFixAxis (a)
	variable a
	variable centerAt=0
	NVAR gain=$("root:maf:mafscopegain" + num2str (a))
	if (checkval ("CenterCheck_" + num2str (a), "mafScope"))
		wave w=$("root:maf:mafScopeWave" + num2str (a))
		NVAR mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
		centerAt = pmean (w, 0, x2pnt (w, mafScopeSweepDrtn * .1) - 1)
	endif
	setaxis /z $("left" + num2str(a)) -100 / gain + centerAt, 100/gain + centerAt
end
Function GridCheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	modifygraph grid=checked
End
Function FFTCheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	NVAR mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
	wave mafScopeStimIndicator=root:maf:mafScopeStimIndicator
	setaxis /z bottom 0, (checked ? (1/mafScopeSweepDrtn * 256) : mafScopeSweepDrtn)
//	setscale /p x, leftx (mafScopeStimIndicator), deltax (mafScopeStimIndicator), selectstring (checked, "s", "Hz"), mafScopeStimIndicator
End

function mafScopePulseAmp (ch)
	variable ch
	NVAR pulseamp = $("root:maf:mafscopepulseamp" + selectstring (mafitc_isCC(ch),  "VC", "CC" ) + num2str (ch))
	return (pulseamp)
end

Window mafscope() : Graph
	PauseUpdate; Silent 1		// building window...
	String fldrSav0= GetDataFolder(1)
	SetDataFolder root:maf:
	Display /W=(432.75,44,803.25,465.5)/K=1 /L=lefts mafScopeStimIndicator as "mafScope"
	AppendToGraph/L=left0 mafScopeWave0
	SetDataFolder fldrSav0
	ModifyGraph margin(left)=50
	ModifyGraph lSize(mafScopeStimIndicator)=3
	ModifyGraph rgb(mafScopeStimIndicator)=(0,0,0)
	ModifyGraph live=1
	ModifyGraph zero=2
	ModifyGraph noLabel(lefts)=2
	ModifyGraph axThick(lefts)=0
	ModifyGraph lblPos=50
	ModifyGraph freePos(lefts)=0
	ModifyGraph freePos(left0)=0
	ModifyGraph axisEnab(lefts)={0.99,1}
	Label left0 "Ch 0 (\\U)"
	SetAxis lefts 0,0
	SetAxis bottom 0,0.005
	SetAxis left0 -100,100
	ControlBar 74
	CheckBox CenterCheck_0,pos={96,54},size={58,14},title="Center"
	CheckBox CenterCheck_0,help={"Check this box to automatically center the trace"}
	CheckBox CenterCheck_0,value= 0
	CheckBox PulseCheck_0,pos={0,54},size={44,14},proc=mafScopePulseCheckProc,title="Pulse"
	CheckBox PulseCheck_0,help={"Check this box to deliver specified pulse"}
	CheckBox PulseCheck_0,value= 1
	Button GoStopButton,pos={438,1},size={50,20},proc=mafScopeGoStopProc,title="Go"
	Button GoStopButton,help={"Click \"Go\" to start oscilloscope, and \"Stop\" to stop it"}
	Button SetHP0_0,pos={63,35},size={20,17},proc=mafScopeHPButtons,title="0"
	Button SetHP0_0,help={"Set holding potential to 0 mV"}
	Button SetHP70_0,pos={83,35},size={25,17},proc=mafScopeHPButtons,title="-70"
	Button SetHP70_0,help={"Set holding potential to -70 mV"}
	SetVariable ClipWarning,pos={320,1},size={58,32},title=" "
	SetVariable ClipWarning,help={"Clip warning.  If the trace is out of bounds, this area warns you which way"}
	SetVariable ClipWarning,fSize=24,frame=0
	SetVariable ClipWarning,limits={0,Inf,0},value= root:maf:mafScopeClip,noedit= 1
	Button SetHP0_1,pos={223,35},size={20,17},proc=mafScopeHPButtons,title="0"
	Button SetHP0_1,help={"Set holding potential to 0 mV"}
	Button SetHP70_1,pos={243,35},size={25,17},proc=mafScopeHPButtons,title="-70"
	Button SetHP70_1,help={"Set holding potential to -70 mV"}
	CheckBox CenterCheck_1,pos={256,54},size={58,14},title="Center"
	CheckBox CenterCheck_1,help={"Check this box to automatically center the trace"}
	CheckBox CenterCheck_1,value= 0
	CheckBox PulseCheck_1,pos={160,54},size={44,14},proc=mafScopePulseCheckProc,title="Pulse"
	CheckBox PulseCheck_1,help={"Check this box to deliver specified pulse"}
	CheckBox PulseCheck_1,value= 1
	CheckBox Ch0Check,pos={0,1},size={40,14},proc=ChCheckProc,title="Ch 0"
	CheckBox Ch0Check,variable= root:maf:mafScopeCh0On
	CheckBox Ch1Check,pos={160,1},size={40,14},proc=ChCheckProc,title="Ch 1"
	CheckBox Ch1Check,variable= root:maf:mafScopeCh1On
	SetVariable setvar2,pos={63,0},size={95,32},title=" "
	SetVariable setvar2,help={"Pipette resistance measured for channel 0"},fSize=24
	SetVariable setvar2,limits={0,Inf,0},value= root:maf:mafScopeRStr0,noedit= 1
	SetVariable setvar2_1,pos={222,0},size={95,32},title=" "
	SetVariable setvar2_1,help={"Pipette resistance measured for channel 1"}
	SetVariable setvar2_1,fSize=24
	SetVariable setvar2_1,limits={0,Inf,0},value= root:maf:mafScopeRStr1,noedit= 1
	CheckBox TTLCheck3,pos={349,37},size={53,14},proc=mafScopePulseCheckProc,title="TTL0-3"
	CheckBox TTLCheck3,value= 0
	CheckBox TTLCheck0,pos={304,37},size={16,14},proc=mafScopePulseCheckProc,title=""
	CheckBox TTLCheck0,value= 0
	CheckBox TTLCheck2,pos={334,37},size={16,14},proc=mafScopePulseCheckProc,title=""
	CheckBox TTLCheck2,value= 0
	CheckBox TTLCheck1,pos={319,37},size={16,14},proc=mafScopePulseCheckProc,title=""
	CheckBox TTLCheck1,value= 0
	SetVariable setPulse1,pos={208,54},size={49,16},proc=mafScopeMakeStimProc,title=" "
	SetVariable setPulse1,help={"Pulse amplitude (in mV)"}
	SetVariable setPulse1,limits={-Inf,Inf,0},value= root:maf:mafScopePulseAmpVC1
	SetVariable setPulse0,pos={48,54},size={49,16},proc=mafScopeMakeStimProc,title=" "
	SetVariable setPulse0,help={"Pulse amplitude (in mV)"}
	SetVariable setPulse0,limits={-Inf,Inf,0},value= root:maf:mafScopePulseAmpCC0
	SetVariable SweepIval,pos={407,40},size={83,16},proc=mafScopeUpdateInterval,title="Intrvl"
	SetVariable SweepIval,help={"Interval between sweeps (in seconds)"}
	SetVariable SweepIval,format="%G s"
	SetVariable SweepIval,limits={0,Inf,0.5},value= root:maf:mafScopeSweepInterval
	SetVariable setPulseDrtn,pos={408,24},size={82,16},proc=mafScopeMakeStimProc,title="Drtn"
	SetVariable setPulseDrtn,help={"Pulse duration, as a percentage of the total sweep duration"}
	SetVariable setPulseDrtn,format="%G ms"
	SetVariable setPulseDrtn,limits={0,4,0.5},value= root:maf:mafScopePulseDrtn
	SetVariable SweepDrtn,pos={406,56},size={84,16},proc=mafScopeMakeStimProc,title="Sweep"
	SetVariable SweepDrtn,help={"Sweep duration"},format="%G s"
	SetVariable SweepDrtn,value= root:maf:mafScopeSweepDrtn,noedit= 1
	SetVariable SetHP_0,pos={0,36},size={63,16},proc=HPFieldProc,title=" "
	SetVariable SetHP_0,format="%g mV"
	SetVariable SetHP_0,limits={-Inf,Inf,10},value= root:maf:mafITC_HP[0]
	SetVariable SetHP_1,pos={160,36},size={63,16},proc=HPFieldProc,title=" "
	SetVariable SetHP_1,format="%g mV"
	SetVariable SetHP_1,limits={-Inf,Inf,10},value= root:maf:mafITC_HP[1]
	CheckBox CCCheck_1,pos={270,44},size={32,14},proc=mafScopeCCCheckProc,title="CC"
	CheckBox CCCheck_1,help={"Check this box to use current clamp"},value= 0,mode=1
	CheckBox CCCheck_0,pos={112,44},size={32,14},proc=mafScopeCCCheckProc,title="CC"
	CheckBox CCCheck_0,help={"Check this box to use current clamp"},value= 1,mode=1
	CheckBox VCCheck_1,pos={270,32},size={32,14},proc=mafScopeCCCheckProc,title="VC"
	CheckBox VCCheck_1,help={"Check this box to use voltage clamp"},value= 1,mode=1
	CheckBox VCCheck_0,pos={112,32},size={32,14},proc=mafScopeCCCheckProc,title="VC"
	CheckBox VCCheck_0,help={"Check this box to use voltage clamp"},value= 0,mode=1
	Button StoreButton,pos={324,52},size={39,19},proc=mafScopeStoreButtonProc,title="Store"
	Button StoreButton,help={"Store current scope traces"}
	Button ParamsButton01,pos={365,51},size={39,20},proc=mafScopeSaveSettings,title="Save"
	Button ParamsButton01,help={"Click here to setup A/D and D/A scaling parameters"}
	Button IncGain_0,pos={1,17},size={20,17},proc=mafScopeGainButtons,title="\\Z18+"
	Button IncGain_0,help={"Increase gain on channel 0"}
	Button DecGain_0,pos={22,17},size={20,17},proc=mafScopeGainButtons,title="\\Z18"
	Button DecGain_0,help={"Decrease gain on channel 0"}
	Button IncGain_1,pos={160,15},size={20,17},proc=mafScopeGainButtons,title="\\Z18+"
	Button IncGain_1,help={"Increase gain on channel 1"}
	Button DecGain_1,pos={182,15},size={20,17},proc=mafScopeGainButtons,title="\\Z18"
	Button DecGain_1,help={"Decrease gain on channel 1"}
	CheckBox FFTCheck,pos={385,2},size={37,14},proc=FFTCheckProc,title="FFT"
	CheckBox FFTCheck,value= 0
	CheckBox GridCheck,pos={385,14},size={37,14},proc=GridCheckProc,title="Grid"
	CheckBox GridCheck,value= 0
	SetDrawLayer UserFront
	SetDrawEnv linefgc= (65535,0,0),fillfgc= (65535,0,0),fsize= 24,fstyle= 8,textrgb= (65535,0,0),textrot= 180
	SetDrawEnv save
EndMacro

Function gainScaler (currentgain, incval)
	variable currentgain, incval
	variable gaindigit = round (10^(log (currentgain) - floor (log (currentgain))))
	
	if (incval == 1)
		return (((gaindigit == 1) || (gaindigit == 5)) ? 2 : 2.5)
	else
		return (((gaindigit == 1) || (gaindigit == 2)) ? .5 : .4)
	endif
end
Function mafScopeGainButtons(ctrlName) : ButtonControl
	String ctrlName
	NVAR gain0=root:maf:mafScopeGain0, gain1=root:maf:mafScopeGain1
	strswitch (ctrlname)
		case "IncGain_0":
			gain0 *= gainScaler (gain0, 1)
			mafScopeFixAxis (0)
			break
		case "DecGain_0":
			gain0 *= gainScaler (gain0, -1)
			mafScopeFixAxis (0)
			break
		case "IncGain_1":
			gain1 *= gainScaler (gain1, 1)
			mafScopeFixAxis (1)
			break
		case "DecGain_1":
			gain1 *= gainScaler (gain1, -1)
			mafScopeFixAxis (1)
			break
	endswitch
End

Function mafScopeHPButtons(ctrlName) : ButtonControl
	String ctrlName
	variable channel, temphp
	
	channel = str2num (ctrlname[strlen (ctrlname) - 1])
	if (!cmpstr (ctrlName, "SetHP0_0") || !cmpstr (ctrlName, "SetHP0_1"))
		temphp = 0
	elseif (!cmpstr (ctrlName, "SetHP70_0") || !cmpstr (ctrlName, "SetHP70_1"))
		temphp = -70
	endif
	mafITC_SetHP (channel, temphp)
	mafScopeMakeStimProc("",0,"","")
end
Function HPFieldProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName, varStr, varName
	Variable varNum
	variable channel
	channel = str2num (ctrlname[strlen (ctrlname) - 1])
	mafITC_SetHP (channel, varNum)
	mafScopeMakeStimProc("",0,"","")
End


Function ChCheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	NVAR Ch0Wanted=root:maf:mafScopeCh0On, Ch1Wanted=root:maf:mafScopeCh1On
	string displayedtraces = TraceNameList("", ";", 1)
	variable Ch0AlreadyOn = (FindListItem("mafScopeWave0", displayedtraces) != -1)
	variable Ch1AlreadyOn = (FindListItem("mafScopeWave1", displayedtraces) != -1)
	NVAR mafScopeGoing=root:maf:mafScopeGoing
	
	if ((Ch0Wanted == 1) && !Ch0AlreadyOn)
		appendtograph /l=left0 root:maf:mafscopewave0
		mafscopefixaxis (0)
		label left0 "Ch 0 (\U)"
	endif
	if ((Ch0Wanted == 0) && Ch0AlreadyOn)
		removefromgraph mafscopewave0
	endif
	if ((Ch1Wanted == 1) && !Ch1AlreadyOn)
		appendtograph /l=left1 root:maf:mafscopewave1
		mafscopefixaxis (1)
		modifygraph rgb(mafscopewave1)=(0,0,65535)
		label left1 "Ch 1 (\U)"
	endif
	if ((Ch1Wanted == 0) && Ch1AlreadyOn)
		removefromgraph mafscopewave1
	endif
	if ((Ch0Wanted == 1) && (Ch1Wanted == 1))
		modifygraph axisenab(left0)={.53, 1}, axisenab(left1)={0, .47}
	else
		modifygraph axisenab={0, 1}; modifygraph axisenab(lefts)={0.99, 1}
	endif
	mafScopeMakeStimProc("SweepDrtn",0,"","")
	ModifyGraph lblPos=50,freePos=0, live=1, zero=2, grid=checkval ("GridCheck", "mafScope")
	if ((Ch0Wanted == 0) && (Ch1Wanted == 0) && mafScopeGoing)
		mafScopeGoStopProc ("")
	endif
	// ModifyGraph margin(left)=50
End


Function mafScopeGoStopProc(ctrlName) : ButtonControl
	String ctrlName
	NVAR mafScopeGoing=root:maf:mafScopeGoing
	NVAR mafScopeSweepInterval=root:maf:mafScopeSweepInterval
	variable ch0On = checkval ("Ch0Check", "mafScope"), Ch1On=checkval ("Ch1Check", "mafScope"), tempRc, tempRs, temptau

	if ((!Ch0On && !Ch1On) || mafScopeGoing)
		CtrlBackground stop
		Button GoStopButton title="Go", win=mafScope
		mafScopeGoing = 0
		// print out parameters to history
//		if (Ch0On && !mafITC_isCC(0) && )
//			tempRc = mean (mafScopeRAvg0, 0, mafScopeRAvgNum - 1)
//			printf "R(cell) = " + mafnum2str (tempRc, 2, 1) + ""
//			if ((checkval ("PulseCheck_0", "mafScope") == 1) && (mafScopePulseAmp0 != 0) && (mafScopePulseDrtn > 0))
//				tempRs = mafScopePulseAmp0 *1e-3 / (epscmaxpeak (mafScopeWave0, mafScopeSweepDrtn * .1, mafScopeSweepDrtn * .1 + mafScopePulseDrtn /1000)) / 1e-12)
//				printf "; R(seal) = " + mafnum2str (tempRs, 2, 1) + ""
//				temptau = posttau (mafScopeWave0, (mafScopeSweepDrtn + mafScopePulseDrtn) * .1, 
//				print "; C(cell) = " + mafnum2str (tempval, 2, 1) + "F"
//		endif
//		if (Ch1On && !mafITC_isCC(1))
//		endif
	else
		Button GoStopButton title="Stop", win=mafScope
		SetBackground mafScopeDoSweep()
		CtrlBackground start, period=(mafScopeSweepInterval*60)
		mafScopeGoing = 1
	endif
End

function mafScopeDoSweep()
	wave mafScopeStimWave=root:maf:mafScopeStimWave
	NVAR mafScopePulseDrtn=root:maf:mafScopePulseDrtn, mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
	NVAR mafScopeStoreCount=root:maf:mafScopeStoreCount
	SVAR mafScopeClip=root:maf:mafScopeClip
	NVAR mafScopeRAvgIndex=root:maf:mafScopeRAvgIndex, mafScopeRAvgNum=root:maf:mafScopeRAvgNum
	variable numch, tempval, baseline, i, startpt, endpt, woffset
	string tempch = "", istr
	variable Ch0On=checkval ("Ch0Check", "mafScope"), Ch1On=checkval ("Ch1Check", "mafScope")
	variable TTLOn=checkval ("TTLCheck0", "mafScope") + 2 * checkval ("TTLCheck1", "mafScope") + 4 * checkval ("TTLCheck2", "mafScope") + 8 * checkval ("TTLCheck3", "mafScope")
	variable FFTCheck=checkval ("FFTCheck", "mafScope")
	mafScopeClip = ""

	// collect next wave
	tempch = selectstring (Ch0On, "", "0") + selectstring (Ch1On, "", "1") + selectstring (TTLOn, "", "D")
	make /o/n=(numpnts (mafScopeStimWave)) root:maf:mafScopeWave
	wave mafScopeWave=root:maf:mafScopeWave
	if (mafITC_isITC18 ())
		execute "ITC18seq \"" + tempch + "\" , \"" + tempch + "\""		// calls for ITC18
		execute "ITC18StimAndSample root:maf:mafScopeStimWave, root:maf:mafScopeWave, " + num2str (deltax(mafScopeStimWave) * .8e6) + ", 2, 0"
	else
		execute "ITC16seq \"" + tempch + "\" , \"" + tempch + "\""		// calls for ITC16
		execute "ITC16StimAndSample mafScopeStimWave, mafScopeWave, " + num2str (deltax(mafScopeStimWave) * 1e6) + ", 2"
	endif
	numch = strlen(tempch)
	startpt = x2pnt (mafScopeStimWave, .1 * mafscopesweepdrtn) / numch
	endpt = startpt + x2pnt (mafScopeStimWave, mafScopePulseDrtn/1000) / numch - 1
	for (i = 0; i < 2; i += 1)	// process result waves
		istr = num2str (i)
		SVAR RStr=$("root:maf:mafScopeRStr" + istr)
		if (checkval ("Ch" + istr + "Check", "mafScope"))		
			tempval = mafITC_ADGain (i) * 3.2		// 3.2 = 32768 pnts / 10240 mV
			woffset = strsearch(tempch, istr, 0)
			if (FFTCheck)
				make /o/n=(numpnts (mafscopewave) / numch) root:maf:wtemp
				WAVE wtemp=root:maf:wtemp
				setscale /p x, 0, deltax (mafscopestimwave) * numch, "s", wtemp
				setscale d, 0, 0, mafITC_Units (i), wtemp
				wtemp = mafscopewave[p * numch + woffset] / tempval		
				FFT /Z /MAG /DEST=$("root:maf:mafScopeWave" + istr) wtemp
				RStr = ""
			else
				make /o/n=(numpnts (mafscopewave) / numch) $("root:maf:mafScopeWave" + istr)
				WAVE w=$("root:maf:mafScopeWave" + istr)
				setscale /p x, 0, deltax (mafscopestimwave) * numch, "s", w
				setscale d, 0, 0, mafITC_Units (i), w
				w = mafscopewave[p * numch + woffset] / tempval		
				baseline = pmean (w, 0, startpt - 1)
				// update running avg of seal resistance
				if ((checkval ("PulseCheck_" + istr, "mafScope") == 1) && (mafScopePulseAmp(i) != 0) && (mafScopePulseDrtn > 0))
					if (mafITC_IsCC(i))
						tempval = 1e9 * (pmean (w, endpt - 5, endpt) - baseline) / mafScopePulseAmp(i)
					else
						tempval = 1e9 * mafScopePulseAmp(i) / (pmean (w, endpt - 5, endpt) - baseline)
					endif
					wave RAvg=$("root:maf:mafScopeRAvg" + istr)
					RAvg[mafScopeRAvgIndex]=tempval
					mafScopeRAvgIndex = mod (mafScopeRAvgIndex + 1, mafScopeRAvgNum)
					RStr = mafnum2str (mean (RAvg, 0, mafScopeRAvgNum - 1), 2, 1) + "Ohm"
				else
					RStr = ""
				endif
				if (checkval ("CenterCheck_" + istr, "mafscope") == 1)
					mafScopeFixAxis (i)
//				if (checkval ("BaselineCheck_" + istr, "mafscope") == 1)
//					w -= baseline
				else
					NVAR Gain=$("root:maf:mafScopeGain" + istr)
					if (baseline < -100/Gain)
						mafScopeClip = "Low"
					endif
					if (baseline > 100/Gain)
						mafScopeClip = "High"
					endif
				endif
			endif
		else
			RStr = ""
		endif
	endfor
	return 0
end

Function mafScopeMakeStimProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName, varStr, varName
	Variable varNum
	
	NVAR mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn, mafScopeLastSweepDrtn=root:maf:mafScopeLastSweepDrtn
	NVAR mafScopePulseDrtn=root:maf:mafScopePulseDrtn
	wave mafScopeStimWave0=root:maf:mafScopeStimWave0
	wave mafScopeStimWave1=root:maf:mafScopeStimWave1
	wave mafScopeStimWaveD=root:maf:mafScopeStimWaveD
	wave mafScopeStimIndicator=root:maf:mafScopeStimIndicator
	variable tempval, i, startpt, endpt, actualsrate
	variable Ch0On=checkval ("Ch0Check", "mafScope"), Ch1On=checkval ("Ch1Check", "mafScope")
	variable TTLOn = checkval ("TTLCheck0", "mafScope") + 2 * checkval ("TTLCheck1", "mafScope") + 4 * checkval ("TTLCheck2", "mafScope") + 8 * checkval ("TTLCheck3", "mafScope")
	variable FFTOn = checkval ("FFTCheck", "mafScope")
	string stimseq = selectstring (Ch0On, "", "0") + selectstring (Ch1On, "", "1") + selectstring (TTLOn, "", "D")
	
	if (mafScopeSweepDrtn != mafScopeLastSweepDrtn)
		if (mafScopeSweepDrtn == mafScopeLastSweepDrtn + 1)
			mafScopeSweepDrtn = mafScopeLastSweepDrtn * gainscaler (mafScopeLastSweepDrtn, 1)
		elseif (mafScopeSweepDrtn == mafScopeLastSweepDrtn - 1)
			mafScopeSweepDrtn = mafScopeLastSweepDrtn * gainscaler (mafScopeLastSweepDrtn, -1)			
		endif
		mafScopeLastSweepDrtn = mafScopeSweepDrtn
		SetVariable setPulseDrtn limits={0,1000 * mafScopeSweepDrtn * .8,1000* mafScopeSweepDrtn * .1}
	endif
	actualsrate = round (mafscopesweepdrtn / numpnts (mafScopeStimWave0) / strlen (stimseq) * 1e6) / 1e6 * strlen (stimseq)
	if (!cmpstr (ctrlName, "SweepDrtn"))
		SetScale/P x 0,actualsrate, "s", mafScopeStimWave0, mafScopeStimWave1, mafScopeStimWaveD
		setaxis /z bottom 0, (FFTOn ? (1/mafScopeSweepDrtn * 256) : mafScopeSweepDrtn)
	endif
	if (mafscopepulsedrtn > .8 * mafscopesweepdrtn * 1000)
		mafscopepulsedrtn = .8 * mafscopesweepdrtn * 1000
	endif

	SetScale/I x mafscopesweepdrtn *.1, mafscopesweepdrtn * .1 + mafscopepulsedrtn/1000,selectstring (FFTOn, "s", "Hz"), mafScopeStimIndicator
	if ((Ch0On && checkval ("PulseCheck_0", "mafScope")) || (Ch1On && checkval ("PulseCheck_1", "mafScope")) || TTLOn)
		mafScopeStimIndicator = 0
	else
		mafscopestimindicator = nan
	endif
	// first build separate stimulation waves, as needed
	
	startpt = x2pnt (mafScopeStimWave0, .1 * mafscopesweepdrtn)
	endpt = startpt + x2pnt (mafScopeStimWave0, mafScopePulseDrtn/1000) - 1
	if (Ch0On)
		mafscopestimwave0 = mafITC_GetHP(0)
		if (checkval ("PulseCheck_0", "mafScope") && (mafScopePulseDrtn > 0))
			mafscopestimwave0[startpt, endpt] += mafScopePulseAmp(0)
		endif
		tempval = mafITC_DAGain(0) * 3.2		// 3.2 = 32768 pnts / 10240 mV
		mafscopestimwave0 *= tempval
	endif
	if (Ch1On)
		mafscopestimwave1 = mafITC_GetHP(1)
		if (checkval ("PulseCheck_1", "mafScope") && (mafScopePulseDrtn > 0))
			mafscopestimwave1[startpt, endpt] += mafScopePulseAmp(1)
		endif
		tempval = mafITC_DAGain(1) * 3.2		// 3.2 = 32768 pnts / 10240 mV
		mafscopestimwave1 *= tempval
	endif
	if (TTLOn)
		mafscopestimwaveD = 0
		if (mafScopePulseDrtn > 0)
			mafScopeStimWaveD[startpt, endpt] = TTLOn
		endif
	endif
	
	// now weave separate stimulation waves together into main wave
	tempval = strlen (stimseq)
	make /o/n=(tempval * numpnts (mafScopeStimWave0)) root:maf:mafScopeStimWave
	wave mafScopeStimWave=root:maf:mafScopeStimWave
	SetScale/P x 0,actualsrate/tempval, "s", mafScopeStimWave
	i = 0
	do
		wave w=$("root:maf:mafscopestimwave" + stimseq[i])
		mafScopeStimWave[i, ; tempval] = w[(p - i) / tempval]
		i += 1
	while (i < strlen (stimseq))
End

Function mafScopePulseCheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	mafScopeMakeStimProc ("", 0, "", "")
End
Function mafScopeCCCheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	string ch=ctrlname[8]
	variable chnum = str2num (ch), IsCC
	wave ScopeWave=$("root:maf:mafScopeWave" + ch)

	checkbox $("CCCheck_" + ch), win= mafScope, value=0
	checkbox $("VCCheck_" + ch), win= mafScope, value=0
	checkbox $ctrlname, win= mafScope, value=1
	isCC = (cmpstr (ctrlname[0], "C") == 0)
	mafITC_SetClamp (chnum, isCC)
	setvariable $("SetPulse" + ch) value=$("root:maf:mafScopePulseAmp" + selectstring (isCC, "VC", "CC") + ch)
	setscale d 0, 0, mafITC_Units (chnum), ScopeWave
	if (IsCC && mafITC_GetHP (chnum) != 0)
		DoAlert 1, "Set holding potential to 0 before switching to current clamp?"
		if (v_flag == 1)
			mafITC_SetHP(chnum, 0)
		endif
	endif
	mafscopefixaxis (chnum)
	mafScopeMakeStimProc ("", 0, "", "")
	print "Channel " + ch + " switched to " + selectstring (isCC, "voltage", "current") + " clamp."
end

Function mafScopeParamsButton(ctrlName) : ButtonControl
	String ctrlName
	mafITC_ShowSettings()
End

Function mafScopeStoreButtonProc(ctrlName) : ButtonControl
	String ctrlName
	NVAR mafScopeStoreCount=root:maf:mafScopeStoreCount
	variable Ch0On=checkval ("Ch0Check", "mafScope"), Ch1On=checkval ("Ch1Check", "mafScope")
	if (Ch0On)
		duplicate /o root:maf:mafScopeWave0 $("mafScope_Ch0_" + num2str (mafScopeStoreCount))
		print "mafScope stored Ch0: mafScope_Ch0_" + num2str (mafScopeStoreCount)
	endif
	if (Ch1On)
		duplicate /o root:maf:mafScopeWave1 $("mafScope_Ch1_" + num2str (mafScopeStoreCount))
		print "mafScope stored Ch1: mafScope_Ch1_" + num2str (mafScopeStoreCount)
	endif
	if (Ch0On || Ch1On)
		mafScopeStoreCount += 1
	endif
End


Function mafScopeUpdateInterval(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName, varStr, varName
	Variable varNum
	NVAR mafScopeGoing=root:maf:mafScopeGoing
	if (mafScopeGoing)
		mafScopeGoStopProc ("")	// call once to turn off
		mafScopeGoStopProc ("")	// call again to turn back on
	endif
End
//*** remember holding current, and holding potential, differentgains in CC vs VC
function initNewMafScope()
	variable i
	string ch
	mafITC_Init ()
	if (exists ("root:maf:mafScopeGain") == 0)
		PathInfo mafPCPath
		if (v_flag == 0)	// i.e. doesn't exist yet
			pathinfo Igor
			newpath /c/q/z mafPCPath, s_path + ":mafPC"
		endif

		make /o/n=8 root:maf:mafScopeGain=1, root:maf:mafScopeCenter=0, root:maf:mafScopePulseOn=0
		make /o/n=8 root:maf:mafScopeLinkedDA=nan, root:maf:mafScopeShow=0
		make /o/n=4 root:maf:mafScopePulseAmpCC=0, root:maf:mafScopePulseAmpVC=0
		make /n=(8,3)/o root:maf:mafScopeColours
		make /o/n=2 root:maf:mafScopeStimIndicator = 0
		make /o/n=4 root:maf:mafScopeTTLOn=0
		variable /g root:maf:mafScopePulseDrtn = 2, root:maf:mafScopeSweepDrtn = .005, root:maf:mafScopeLastSweepDrtn=-1
		variable /g root:maf:mafScopeSweepInterval=0, root:maf:mafScopeGridOn=0, root:maf:mafScopeDoFFT=0
		variable /g root:maf:mafScopeRAvgNum=3, root:maf:mafScopeRAvgIndex=0
		variable /g root:maf:mafScopeGoing = 0
		string /g root:maf:mafScopeClip = "", root:maf:mafScopeRect="243,51.5,624,488.75"
		string /g root:maf:mafScopeSettingsName=""
		wave mafScopeGain=root:maf:mafScopeGain, mafScopeCenter=root:maf:mafScopeCenter
		wave mafScopePulseOn=root:maf:mafScopePulseOn, mafScopeLinkedDA=root:maf:mafScopeLinkedDA
		wave mafScopeTTLOn=root:maf:mafScopeTTLOn
		wave mafScopeColours=root:maf:mafScopeColours
		NVAR mafScopeRAvgNum=root:maf:mafScopeRAvgNum, mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
		NVAR mafScopePulseDrtn=root:maf:mafScopePulseDrtn
		mafScopeColours = {{65535,0,0}, {0,0,65535}, {0,65535,0}, {65535,65535,0}, {65535,0,65535}, {0,65535,65535}, {0,0,0}}
	
		for (i = 0; i < 8; i += 1)
			ch = num2str (i)
			make /o/n=512 $("root:maf:mafScopeWave" + ch)
			wave w=$("root:maf:mafScopeWave" + ch)
			w = nan
			make /o/n=(mafScopeRAvgNum) $("root:maf:mafScopeRAvg" + ch)
			string /g $("root:maf:mafScopeRStr" + ch)=""
		endfor
		for (i = 0; i < 4; i += 1)
			make /o/n=512 $("root:maf:mafScopeStimWave" + num2str (i))
		endfor
		make /o/n=512 root:maf:mafScopeWaveD, root:maf:mafScopeStimWaveD
		mafscopegain = 1
		make /o/n=2 root:maf:mafScopeStimIndicator= 0
		newmafScopeLoadSettings ("default")
	endif
	dowindow mafscopenewer
	if (v_flag == 0)
		Execute "mafscopenewer()"
		mafScopeEnforceSettings()
	endif
	// *** make this part unnecessary
	for (i = 0; i < 8; i += 1)
		wave w=$("root:maf:mafScopeWave" + num2str (i))
		setscale /i x, 0, mafScopeSweepDrtn, "s",w	// stimwaves?***
		setscale d, 0, 0, mafITC_Units (i), w
	endfor
end
function newmafScopeLoadSettings(whichSettings)
	string whichSettings
	variable sfile	// file to hold settings
	variable tempval, i
	string allsettings, tempstr
	
	wave mafScopeGain=root:maf:mafScopeGain, mafScopeCenter=root:maf:mafScopeCenter
	wave mafScopePulseOn=root:maf:mafScopePulseOn, mafScopeLinkedDA=root:maf:mafScopeLinkedDA
	wave mafScopePulseAmpCC=root:maf:mafScopePulseAmpCC, mafScopePulseAmpVC=root:maf:mafScopePulseAmpVC
	wave mafScopeShow=root:maf:mafScopeShow, mafScopeTTLOn=root:maf:mafScopeTTLOn
	wave mafScopeColours=root:maf:mafScopeColours
	NVAR mafScopePulseDrtn=root:maf:mafScopePulseDrtn, mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
	NVAR mafScopeSweepInterval=root:maf:mafScopeSweepInterval
	NVAR mafScopeGridOn=root:maf:mafScopeGridOn, mafScopeDoFFT=root:maf:mafScopeDoFFT
	SVAR mafScopeRect=root:maf:mafScopeRect

	if (strlen (whichsettings) == 0)
		whichsettings = "default"
	endif
	open /t="IGBW"/z/r/p=mafPCPath sfile as whichsettings + ".scp"
	if (v_flag == 0)	// i.e. file exists
		freadline sfile, allsettings
		close sfile
		mafScopeShow = getgoodval ("Show" + num2str (p), allsettings, mafScopeShow)
		mafScopeGain = getgoodval ("Gain" + num2str (p), allsettings, mafScopeGain)
		mafScopeCenter = getgoodval ("Center" + num2str (p), allsettings, mafScopeCenter)
		mafScopePulseOn = getgoodval ("PulseOn" + num2str (p), allsettings, mafScopePulseOn)
		mafScopeLinkedDA = getgoodval ("LinkedDA" + num2str (p), allsettings, mafScopeLinkedDA)
		mafScopePulseAmpVC = getgoodval ("PulseAmpVC" + num2str (p), allsettings, mafScopePulseAmpVC)
		mafScopePulseAmpCC = getgoodval ("PulseAmpCC" + num2str (p), allsettings, mafScopePulseAmpCC)
		mafScopeTTLOn = getgoodval ("TTLOn" + num2str (p), allsettings, mafScopeTTLOn)
		tempstr = getgoodstr ("Colours", allsettings, wave2list (mafscopeColours, ",")); list2wave (tempstr, mafScopeColours, ",")
		mafScopePulseDrtn = getgoodval ("PulseDrtn", allsettings, mafScopePulseDrtn)
		mafScopeSweepDrtn = getgoodval ("SweepDrtn", allsettings, mafScopeSweepDrtn)
		mafScopeSweepInterval = getgoodval ("SweepInterval", allsettings, mafScopeSweepInterval)
		mafScopeGridOn = getgoodval ("GridOn", allsettings, mafScopeGridOn)
		mafScopeDoFFT = getgoodval ("DoFFT", allsettings, mafScopeDoFFT)
		mafScopeRect = getgoodstr ("Rect", allsettings, mafScopeRect)	// now what?
		for (i = 0; i < 8; i += 1)
			tempval = getgoodval ("isCC" + num2str (i), allsettings, mafITC_isCC (i))
			mafITC_SetClamp (i, tempval)
		endfor
	endif
	controlupdate /a
end
static function getgoodval (keystr, liststr, oldval)
	string keystr, liststr
	variable oldval
	variable tempval
	tempval = numberbykey (keystr, liststr)
	return (numtype (tempval) == 0 ? tempval : oldval)
end
static function /t getgoodstr (keystr, liststr, oldstr)
	string keystr, liststr, oldstr
	string tempstr
	tempstr = stringbykey (keystr, liststr)
	return (selectstring (strlen (tempstr) > 0, oldstr, tempstr))
end
function mafScopeEnforceSettings ()
	wave mafScopeShow=root:maf:mafScopeShow, mafScopeTTLOn=root:maf:mafScopeTTLOn
	NVAR mafscopesweepdrtn=root:maf:mafscopesweepdrtn, mafscopepulsedrtn=root:maf:mafscopepulsedrtn
	NVAR mafScopeGridOn=root:maf:mafScopeGridOn, mafScopeDoFFT=root:maf:mafScopeDoFFT
	SVAR mafScopeRect=root:maf:mafScopeRect
	variable i, ptleft, pttop, ptright, ptbottom
	
	dowindow mafScopeNewer
	if (v_flag == 0)
		return 0
	endif
	// set window location
	pttop = str2num (stringfromlist (0, mafScopeRect, ",")); ptleft = str2num (stringfromlist (1, mafScopeRect, ","))
	ptbottom = str2num (stringfromlist (2, mafScopeRect, ",")); ptright = str2num (stringfromlist (3, mafScopeRect, ","))
	movewindow /W=mafscopenewer ptleft, pttop, ptright, ptbottom
	
	SetScale/I x mafscopesweepdrtn *.1, mafscopesweepdrtn * .1 + mafscopepulsedrtn/1000,"s", root:maf:mafScopeStimIndicator	// *** shouldn't need this
	// setup TTLs
	for (i = 0; i < 4; i += 1)
		CheckBox $("TTLCheck" + num2str (i)),win=mafScopeNewer#PTOP,value=mafScopeTTLOn[i]	
	endfor
	// show correct channels
	for (i = 0; i < 8; i += 1)
		CheckBox $("Show" + num2str (i)),win=mafScopeNewer#PTOP,value=mafScopeShow[i]	
		NewChProc ("Show" + num2str (i), mafScopeShow[i])
		// takes care of setting up sidebar for correct values
		// also sets up stimulus
		if (mafScopeShow[i])
			newmafScopeFixAxis (i)
		endif
	endfor
	GridCheckProc ("",mafScopeGridOn)
	FFTCheckProc ("", mafScopeDoFFT)
end
function /t configProc()
	SVAR mafScopeSettingsName=root:maf:mafScopeSettingsName
	string tempstr = replacestring (".scp", removefromlist ("default", indexedfile (mafPCPath, -1, ".scp")), "")
	
	if (itemsinlist (tempstr) > 0)
		tempstr += ";(-;"
	endif
	if (strlen (mafScopeSettingsName) > 0)
		tempstr += "Save \"" + mafScopeSettingsName + "\";"
	endif
	return tempstr + "Save as default;Save as other..."
end
Function mafScopeDoConfig(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName, popStr
	Variable popNum
	SVAR mafScopeSettingsName=root:maf:mafScopeSettingsName
	string tempstr = replacestring (".scp", removefromlist ("default", indexedfile (mafPCPath, -1, ".scp")), "")
	string newname = mafScopeSettingsName
	
	if (findlistitem (popStr, tempstr) != -1)	// user selected a pre-existing setting
		newmafScopeLoadSettings (popStr)
		mafScopeSettingsName = popStr
		mafScopeEnforceSettings ()
	elseif (cmpstr (popstr, "Save as default") == 0)
		newmafScopeSaveSettings ("")
	elseif (cmpstr (popstr, "Save \"" + mafScopeSettingsName + "\"") == 0)
		newmafScopeSaveSettings (mafScopeSettingsName)
	elseif (cmpstr (popstr, "Save as other...") == 0)
		// get file name
		prompt newname, "Enter the configuration name [blank for default]:"
		doprompt "Store configuration:", newname
		if (v_flag == 0)
			newmafScopeSaveSettings (newname)
			if (cmpstr (newname, "default") == 0)
				mafScopeSettingsName = ""
			else
				mafScopeSettingsName = newname
			endif
		endif
	endif
End

function newmafScopeSaveSettings (saveName)
	string saveName
	variable sfile	// file to hold settings
	variable tempval, i
	string allsettings=""
	wave mafScopeGain=root:maf:mafScopeGain, mafScopeCenter=root:maf:mafScopeCenter
	wave mafScopePulseOn=root:maf:mafScopePulseOn, mafScopeLinkedDA=root:maf:mafScopeLinkedDA
	wave mafScopePulseAmpCC=root:maf:mafScopePulseAmpCC, mafScopePulseAmpVC=root:maf:mafScopePulseAmpVC
	wave mafScopeShow=root:maf:mafScopeShow, mafScopeTTLOn=root:maf:mafScopeTTLOn
	wave mafScopeColours=root:maf:mafScopeColours
	NVAR mafScopePulseDrtn=root:maf:mafScopePulseDrtn, mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
	NVAR mafScopeSweepInterval=root:maf:mafScopeSweepInterval
	NVAR mafScopeGridOn=root:maf:mafScopeGridOn, mafScopeDoFFT=root:maf:mafScopeDoFFT
	SVAR mafScopeRect=root:maf:mafScopeRect

	for (i = 0; i < 8; i += 1)
		allsettings = replacenumberbykey ("Show" + num2str (i), allsettings, mafScopeShow[i])
		allsettings = replacenumberbykey ("Gain" + num2str (i), allsettings, mafScopeGain[i])
		allsettings = replacenumberbykey ("Center" + num2str (i), allsettings, mafScopeCenter[i])
		allsettings = replacenumberbykey ("PulseOn" + num2str (i), allsettings, mafScopePulseOn[i])
		allsettings = replacenumberbykey ("isCC" + num2str (i), allsettings, mafITC_isCC (i))
		allsettings = replacenumberbykey ("LinkedDA" + num2str (i), allsettings, mafScopeLinkedDA[i])
	endfor
	for (i = 0; i < 4; i += 1)
		allsettings = replacenumberbykey ("PulseAmpVC" + num2str (i), allsettings, mafScopePulseAmpVC[i])
		allsettings = replacenumberbykey ("PulseAmpCC" + num2str (i), allsettings, mafScopePulseAmpCC[i])
		allsettings = replacenumberbykey ("TTLOn" + num2str (i), allsettings, mafScopeTTLOn[i])
	endfor 
	allsettings = replacestringbykey ("Colours", allsettings, wave2list (mafscopeColours, ","))
	allsettings = replacenumberbykey ("PulseDrtn", allsettings, mafScopePulseDrtn)
	allsettings = replacenumberbykey ("SweepDrtn", allsettings, mafScopeSweepDrtn)
	allsettings = replacenumberbykey ("SweepInterval", allsettings, mafScopeSweepInterval)
	allsettings = replacenumberbykey ("GridOn", allsettings, mafScopeGridOn)
	allsettings = replacenumberbykey ("DoFFT", allsettings, mafScopeDoFFT)
	allsettings = replacestringbykey ("Rect", allsettings, mafScopeRect)
	
	if (strlen (savename) == 0)
		savename = "default"
	endif
	open /t="IGBW"/p=mafPCPath sfile as saveName + ".scp"
	fbinwrite sfile, allsettings	// error checking?***
	close sfile
end

// code for setting rectangle according to saved values -- to reinsert into window macro if rebuilt by Igor
//	variable stop, sleft, sbottom, sright
//	stop = num2str (stringfromlist (0, root:maf:mafScopeRect,","); sleft = num2str (stringfromlist (1, root:maf:mafScopeRect,",")
//	sbottom = num2str (stringfromlist (2, root:maf:mafScopeRect,","); sright = num2str (stringfromlist (3, root:maf:mafScopeRect,",")
//	Display /W=(stop, sleft, sbottom, sright)/L=lefts :maf:mafScopeStimIndicator as "mafScopeNewer"
Window mafScopenewer() : Graph
	PauseUpdate; Silent 1		// building window...
	variable stop, sleft, sbottom, sright
	stop = str2num (stringfromlist (0, root:maf:mafScopeRect,",")); sleft = str2num (stringfromlist (1, root:maf:mafScopeRect,","))
	sbottom = str2num (stringfromlist (2, root:maf:mafScopeRect,",")); sright = str2num (stringfromlist (3, root:maf:mafScopeRect,","))
	Display /K=1/W=(stop, sleft, sbottom, sright)/L=lefts :maf:mafScopeStimIndicator as "mafScopeNewer"
	ModifyGraph margin(left)=50
	ModifyGraph lSize(mafScopeStimIndicator)=3
	ModifyGraph rgb(mafScopeStimIndicator)=(0,0,0)
	ModifyGraph live=1
	ModifyGraph noLabel(lefts)=2
	ModifyGraph axThick(lefts)=0
	ModifyGraph lblPos=50
	ModifyGraph freePos(lefts)=0
	ModifyGraph axisEnab(lefts)={0.99,1}
	SetAxis lefts 0,0
	SetAxis bottom 0,0.005
	ControlBar 59
	ControlBar/L 113
	SetWindow kwTopWin,hook(myhook)=mafScopeHook
	SetVariable ClipWarning,pos={284,2},size={58,32},title=" "
	SetVariable ClipWarning,help={"Clip warning.  If the trace is out of bounds, this area warns you which way"}
	SetVariable ClipWarning,fSize=24,frame=0
	SetVariable ClipWarning,limits={0,inf,0},value= root:maf:mafScopeClip,noedit= 1
	NewPanel/W=(0.2,0.2,0.116,0.8)/FG=(FL,GT,GL,FB)/HOST=# 
	ModifyPanel frameStyle=1, frameInset=0
	SetDrawLayer UserBack
	RenameWindow #,PLeft
	SetActiveSubwindow ##
	NewPanel/W=(0,0,1,0)/FG=(FL,FT,GR,GT)/HOST=# 
	ModifyPanel frameStyle=1, frameInset=0
	SetDrawLayer UserBack
	SetDrawEnv fname= "MS Sans Serif"
	DrawText 7,17,"ADC"
	SetDrawEnv fname= "MS Sans Serif"
	DrawText 7,50,"TTL"
	Button GoStopButton,pos={345,6},size={50,20},proc=newmafScopeGoStopProc,title="Go"
	Button GoStopButton,help={"Click \"Go\" to start oscilloscope, and \"Stop\" to stop it"}
	CheckBox TTLCheck3,pos={117,37},size={24,14},proc=mafScopePulseCheck,title="3"
	CheckBox TTLCheck3,value= 0
	CheckBox TTLCheck0,pos={30,37},size={24,14},proc=mafScopePulseCheck,title="0"
	CheckBox TTLCheck0,value= 0
	CheckBox TTLCheck2,pos={88,37},size={24,14},proc=mafScopePulseCheck,title="2"
	CheckBox TTLCheck2,value= 0
	CheckBox TTLCheck1,pos={59,37},size={24,14},proc=mafScopePulseCheck,title="1"
	CheckBox TTLCheck1,value= 0
	SetVariable SweepIval,pos={151,38},size={83,16},proc=newmafScopeUpdateInterval,title="Intrvl"
	SetVariable SweepIval,help={"Interval between sweeps (in seconds)"}
	SetVariable SweepIval,format="%G s"
	SetVariable SweepIval,limits={0,inf,0.5},value= root:maf:mafScopeSweepInterval
	SetVariable setPulseDrtn,pos={152,4},size={82,16},proc=newmafScopeMakeStimProc,title="Drtn"
	SetVariable setPulseDrtn,help={"Pulse duration, as a percentage of the total sweep duration"}
	SetVariable setPulseDrtn,format="%G ms"
	SetVariable setPulseDrtn,limits={0,4,0.5},value= root:maf:mafScopePulseDrtn
	SetVariable SweepDrtn,pos={150,22},size={84,16},proc=newmafScopeMakeStimProc,title="Sweep"
	SetVariable SweepDrtn,help={"Sweep duration"},format="%G s"
	SetVariable SweepDrtn,value= root:maf:mafScopeSweepDrtn,noedit= 1
	CheckBox FFTCheck,pos={243,19},size={37,14},proc=FFTCheckProc,title="FFT"
	CheckBox FFTCheck,variable=root:maf:mafScopeDoFFT
	CheckBox GridCheck,pos={243,5},size={37,14},proc=GridCheckProc,title="Grid"
	CheckBox GridCheck,variable=root:maf:mafScopeGridOn
	PopupMenu ConfigPopup,pos={241,35},size={67,21},title="Config"
	PopupMenu ConfigPopup,mode=0,value= #"ConfigProc()",proc=mafScopeDoConfig
	Button StoreButton,pos={355,35},size={39,19},proc=mafScopeStoreButtonProc,title="Store"
	Button StoreButton,help={"Store current scope traces"}
	CheckBox Show0,pos={30,4},size={24,14},proc=NewChProc,title="0",value= 1
	CheckBox Show1,pos={59,4},size={24,14},proc=NewChProc,title="1",value= 1
	CheckBox Show2,pos={88,4},size={24,14},proc=NewChProc,title="2",value= 0
	CheckBox Show3,pos={117,4},size={24,14},proc=NewChProc,title="3",value= 0
	CheckBox Show4,pos={30,19},size={24,14},proc=NewChProc,title="4",value= 0
	CheckBox Show5,pos={59,19},size={24,14},proc=NewChProc,title="5",value= 0
	CheckBox Show6,pos={88,19},size={24,14},proc=NewChProc,title="6",value= 0
	CheckBox Show7,pos={117,19},size={24,14},proc=NewChProc,title="7",value= 0
	RenameWindow #,PTop
	SetActiveSubwindow ##
EndMacro

Function NewChProc(ctrlName,checked) : CheckBoxControl
	string ctrlname
	variable checked
	string displayedtraces = tracenamelist ("mafScopeNewer", ";", 1)
	variable i, alreadyon, spacing = .05, axisindex, moveothers = 0, counton=0
	NVAR mafScopeGoing=root:maf:mafScopeGoing, mafScopeGridOn=root:maf:mafScopeGridOn
	wave mafScopeCenter=root:maf:mafScopeCenter,mafScopePulseOn=root:maf:mafScopePulseOn
	wave mafScopeColours=root:maf:mafScopeColours,mafScopeLinkedDA=root:maf:mafScopeLinkedDA
	wave mafScopeShow=root:maf:mafScopeShow
	string ch

	mafScopeShow[suffix2num (ctrlName)] = checked
	for (i = 0; i < 8; i += 1)
		ch = num2str (i)
		alreadyon = (findlistitem ("mafScopeWave" + ch, displayedtraces) != -1)
		if (alreadyon && mafScopeShow[i] == 0)	// i.e. current on but now turned off
			removefromgraph $("mafScopeWave" + ch)
			// remove buttons
			killcontrol /w=mafScopeNewer#PLEFT $("Gain_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("IncGain_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("DecGain_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("CenterCheck_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("CenterNow_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("DAPopup_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("VCCheck_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("CCCheck_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("SetHP_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("IncHP_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("DecHP_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("PulseCheck_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("SetPulse_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("ShowR_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("ColorPopup_" + ch)
			killcontrol /w=mafScopeNewer#PLEFT $("Group" + ch)
			moveothers = 1
		elseif (!alreadyon && mafScopeShow[i])	// i.e. currently off but now turned on
			appendtograph /l=$("left" + num2str (i)) $("root:maf:mafScopeWave" + ch)
			label $("left" + ch) "AD" + ch + " (\U)"
			modifygraph rgb($("mafScopeWave" + ch))=(mafScopeColours[0][i], mafScopeColours[1][i], mafScopeColours[2][i]),live($("mafScopeWave" + ch))=1
			ModifyGraph lblPos($("left" + ch))=50,freePos($("left" + ch))=0, zero($("left" + ch))=2

			// add buttons
			SetActiveSubwindow mafScopeNewer#PLEFT
			GroupBox $("Group" + ch),pos={5,2+counton*130},size={106,128},title="AD" + ch,fColor=(mafScopeColours[0][i], mafScopeColours[1][i], mafScopeColours[2][i]),fstyle=1
			TitleBox $("Gain_" + ch),pos={10,20 + counton * 130},size={22,13},title="Gain",frame=0
			Button $("IncGain_" + ch),pos={33,18+counton*130},size={18,17},proc=newmafScopeGainButtons,title="\\Z18+"
			Button $("DecGain_" + ch),pos={54,18+counton*130},size={18,17},proc=newmafScopeGainButtons,title="\\Z18"
			CheckBox $("CenterCheck_" + ch),pos={63,45+counton*130},size={16,14},title="",value=mafScopeCenter[i],proc=newmafScopeCenterCheck
			Button $("CenterNow_" + ch), pos={79,44+counton*130},size={28,16},title="Cntr",proc=newmafScopeDoCenter
			if (findlistitem (DA2name (mafScopeLinkedDA[i]), availableDA (i)) == -1)	// i.e. DA is already linked to another channel
				mafScopeLinkedDA[i] = nan
			endif
			PopupMenu $("DAPopup_" + ch),pos={14,40+counton*130},size={40,30},proc=mafScopeDAPopupProc
			PopupMenu $("DAPopup_" + ch),mode=2,bodyWidth= 60,popvalue=DA2name (mafScopeLinkedDA[i])
			execute "PopupMenu DAPopup_" + ch + ",value=#\"AvailableDA(" + ch + ")\""	// kluge so that value accepts # that is string expression
			CheckBox $("VCCheck_" + ch),pos={75,16+counton*130},size={32,14},mode=1,proc=newmafScopeCCCheckProc,title="VC",value=1-mafITC_isCC(i)
			CheckBox $("CCCheck_" + ch),pos={75,29+counton*130},size={32,14},mode=1,proc=newmafScopeCCCheckProc,title="CC",value=mafITC_isCC(i)
			SetVariable $("SetHP_" + ch),pos={10,67+counton*130},size={45,16},proc=newmafScopeHPField,title=" ",format="%g mV"
			SetVariable $("SetHP_" + ch),limits={-inf,inf,0},value= root:maf:mafITC_HP[i]
			Button $("IncHP_" + ch),pos={54,66+counton*130},size={20,17},proc=newmafScopeHPButtons,title="\\Z18+"
			Button $("DecHP_" + ch),pos={76,66+counton*130},size={20,17},proc=newmafScopeHPButtons,title="\\Z18"
			CheckBox $("PulseCheck_" + ch),pos={10,85+counton*130},size={44,14},proc=mafScopePulseCheck,title="Pulse",value=mafScopePulseOn[i]
			SetVariable $("SetPulse_" + ch),pos={57,85+counton*130},size={38,16},proc=newmafScopeMakeStimProc,title=" ",limits={-inf,inf,0}
			if (mafITC_isCC (i))
				SetVariable $("SetPulse_" + ch),value= root:maf:mafScopePulseAmpCC[i]	// *** i or mafScopeLinkedDA[i]?
			else
				SetVariable $("SetPulse_" + ch),value= root:maf:mafScopePulseAmpVC[i]
			endif			
			SetVariable $("ShowR_" + ch),pos={11,101+counton*130},size={56,25},title=" ",fSize=18
			SetVariable $("ShowR_" + ch),value= $("root:maf:mafScopeRStr" + ch), noedit=1
			PopupMenu $("ColorPopup_" + ch),pos={53,101+counton*130},bodyWidth=35,value="*COLORPOP*",popColor=(mafScopeColours[0][i], mafScopeColours[1][i], mafScopeColours[2][i])
			PopupMenu $("ColorPopup_" + ch),proc=mafScopeColorPopupProc
			SetActiveSubwindow ##
			moveothers = 1
			newmafScopeFixAxis (i)
			// *** need to disable DA-related stuff if noDA
		elseif (moveothers && alreadyon)	// somebody was added or deleted, so move this one (which already exists)
			GroupBox $("Group" + ch),win=mafScopeNewer#PLEFT,pos={5,2+counton*130}
			TitleBox $("Gain_" + ch),win=mafScopeNewer#PLEFT,pos={10,20 + counton * 130}
			Button $("IncGain_" + ch),win=mafScopeNewer#PLEFT,pos={35,18+counton*130}
			Button $("DecGain_" + ch),win=mafScopeNewer#PLEFT,pos={57,18+counton*130}
			CheckBox $("CenterCheck_" + ch),win=mafScopeNewer#PLEFT,pos={79,19+counton*130}
			PopupMenu $("DAPopup_" + ch),win=mafScopeNewer#PLEFT,pos={9,40+counton*130}
			CheckBox $("VCCheck_" + ch),win=mafScopeNewer#PLEFT,pos={72,50+counton*130}
			CheckBox $("CCCheck_" + ch),win=mafScopeNewer#PLEFT,pos={72,37+counton*130}
			SetVariable $("SetHP_" + ch),win=mafScopeNewer#PLEFT,pos={10,67+counton*130}
			Button $("IncHP_" + ch),win=mafScopeNewer#PLEFT,pos={54,66+counton*130}
			Button $("DecHP_" + ch),win=mafScopeNewer#PLEFT,pos={76,66+counton*130}
			CheckBox $("PulseCheck_" + ch),win=mafScopeNewer#PLEFT,pos={10,85+counton*130}
			SetVariable $("SetPulse_" + ch),win=mafScopeNewer#PLEFT,pos={57,85+counton*130}
			SetVariable $("ShowR_" + ch),win=mafScopeNewer#PLEFT,pos={11,101+counton*130}
			PopupMenu $("ColorPopup_" + ch),win=mafScopeNewer#PLEFT,pos={63,101+counton*130}	// Igor bug: 10 + real position
		endif
		counton += mafScopeShow[i]
	endfor
	newmafScopeMakeStimProc("SweepDrtn",0,"","")
	axisindex = 0
	for (i = 0; i < 8; i += 1)		// fix axis spacing
		ch = num2str (i)
		if (mafScopeShow[i])
			// don't ask me how I came up with this
			modifygraph axisenab($"left" + ch)={max(0,1 - (axisindex + 1) * (1 + spacing) / counton + spacing), min(1,1 - axisindex * (1 + spacing) / counton)}
			axisindex += 1
		endif
	endfor
	if (mafScopeGridOn)
		modifygraph grid=1
 	endif
	if (counton == 0 && mafScopeGoing)
//		mafScopeGoStopProc ("")
	endif
	
end
function /t availableDA (ch)
	variable ch
	wave mafScopeShow=root:maf:mafScopeShow, mafScopeLinkedDA=root:maf:mafScopeLinkedDA
	variable i
	string popupstr = "no DA;DA0;DA1;DA2;DA3"
	for (i = 0; i < 7; i += 1)
		if (i != ch && mafScopeShow[i] && numtype (mafScopeLinkedDA[i]) == 0)
			popupstr = removefromlist ("DA" + num2str (mafScopeLinkedDA[i]), popupstr)
		endif
	endfor
	return popupstr
end
Function mafScopeDAPopupProc(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName, popStr
	Variable popNum
	string ch=num2str (suffix2num (ctrlName))
	variable d
	wave mafScopeLinkedDA=root:maf:mafScopeLinkedDA
	
	d = (popNum == 1) * 2
	setvariable $("SetHP_" + ch),win=mafScopeNewer#PLEFT, disable = d
	button $("IncHP_" + ch),win=mafScopeNewer#PLEFT, disable = d
	button $("DecHP_" + ch),win=mafScopeNewer#PLEFT, disable = d
	checkbox $("Pulsecheck_" + ch),win=mafScopeNewer#PLEFT, disable = d
	setvariable $("SetPulse_" + ch),win=mafScopeNewer#PLEFT, disable = d
	if (!d)	// i.e. a valid DA was selected
		if (mafITC_isCC (str2num (ch)))
			SetVariable $("SetPulse_" + ch),win=mafScopeNewer#PLEFT,value= root:maf:mafScopePulseAmpCC[str2num (ch)]	// *** i or mafScopeLinkedDA[i]?
		else
			SetVariable $("SetPulse_" + ch),win=mafScopeNewer#PLEFT,value= root:maf:mafScopePulseAmpVC[str2num (ch)]
		endif			
	endif
	SVAR rstr=$("root:maf:mafScopeRStr" + ch)
	rstr = ""
	mafscopeLinkedDA[str2num (ch)] = (popNum == 1) ? nan : suffix2num (popstr)
	newmafscopeMakeStimProc ("",0,"","")
end
function /t DA2name (val)
	variable val
	return selectstring (numtype (val) == 2, "DA" + num2str (val), "no DA")
end
Function newmafScopeGainButtons(ctrlName) : ButtonControl
	String ctrlName
	wave mafScopeGain=root:maf:mafScopeGain
	variable ch=suffix2num (ctrlname)
	mafScopeGain[ch] *= gainScaler (mafScopeGain[ch], cmpstr (prefix2str (ctrlName), "IncGain_") == 0 ? 1 : -1)
	newmafScopeFixAxis (ch)
End

Function newmafScopeCenterCheck (ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked			// 1 if selected, 0 if not
	wave mafScopeCenter=root:maf:mafScopeCenter
	mafScopeCenter[suffix2num (ctrlName)] = checked
End
function newmafScopeDoCenter (ctrlName) : ButtonControl
	string ctrlName
	variable a=suffix2num (ctrlName)
	variable centerAt=0
	wave mafScopeGain=root:maf:mafScopeGain, mafScopeCenter=root:maf:mafScopeCenter
	wave w=$("root:maf:mafScopeWave" + num2str (a))
	NVAR mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
	centerAt = pmean (w, 0, x2pnt (w, mafScopeSweepDrtn * .1) - 1)
	setaxis /z $("left" + num2str(a)) -100 / mafScopeGain[a] + centerAt, 100/mafScopeGain[a] + centerAt

	//newmafScopeFixAxis (suffix2num (ctrlname))
end
Function mafScopePulseCheck (ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked			// 1 if selected, 0 if not
	wave mafScopePulseOn=root:maf:mafScopePulseOn
	wave mafScopeTTLOn=root:maf:mafScopeTTLOn
	strswitch (prefix2str (ctrlName))
		case "TTLCheck":
			mafScopeTTLOn[suffix2num (ctrlName)] = checked
			break
		case "PulseCheck_":
			mafScopePulseOn[suffix2num (ctrlName)] = checked		
			break
	endswitch
	newMafScopeMakeStimProc ("", 0, "", "")
End
Function mafScopeColorPopupProc (ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName,popStr
	Variable popNum	// which item is currently selected (1-based)
	variable ch=suffix2num (ctrlName)
	string chstr = num2str (ch)
	wave mafScopeColours=root:maf:mafScopeColours
	ControlInfo /w=mafScopeNewer#PLEFT $ctrlName 
	mafScopeColours[0][ch]=v_red; mafScopeColours[1][ch]=v_green; mafScopeColours[2][ch]=v_blue
	GroupBox $("Group" + chstr),win=mafScopeNewer#PLEFT,fcolor=(v_red,v_green,v_blue)
	modifygraph rgb($("mafScopeWave" + chstr))=(v_red,v_green,v_blue)
End
function newmafScopeFixAxis (a)
	variable a
	variable centerAt=0
	wave mafScopeGain=root:maf:mafScopeGain, mafScopeCenter=root:maf:mafScopeCenter
	if (mafScopeCenter[a])
		wave w=$("root:maf:mafScopeWave" + num2str (a))
		NVAR mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
		centerAt = pmean (w, 0, x2pnt (w, mafScopeSweepDrtn * .1) - 1)
	endif
	setaxis /z $("left" + num2str(a)) -100 / mafScopeGain[a] + centerAt, 100/mafScopeGain[a] + centerAt
end
Function newmafScopeCCCheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	string ch=ctrlname[8]
	variable chnum = str2num(ch), isCC
	wave ScopeWave=$("root:maf:mafScopeWave" + ch)

	checkbox $("CCCheck_" + ch), win= mafScopeNewer#PLEFT, value=0
	checkbox $("VCCheck_" + ch), win= mafScopeNewer#PLEFT, value=0
	checkbox $ctrlname, win= mafScopeNewer#PLEFT, value=1
	isCC = (cmpstr (ctrlname[0], "C") == 0)
	mafITC_SetClamp (chnum, isCC)
	setvariable $("SetPulse_" + ch),win=mafScopeNewer#PLEFT, value=$("root:maf:mafScopePulseAmp" + selectstring (isCC, "VC", "CC"))[chnum]
	setscale d 0, 0, mafITC_Units (chnum), ScopeWave
	if (IsCC && mafITC_GetHP (chnum) != 0)
		DoAlert 1, "Set holding potential to 0 before switching to current clamp?"
		if (v_flag == 1)
			mafITC_SetHP(chnum, 0)
		endif
	endif
	newmafscopefixaxis (chnum)
	newmafScopeMakeStimProc ("", 0, "", "")
	print "Channel " + ch + " switched to " + selectstring (isCC, "voltage", "current") + " clamp."
end
Function mafScopeHook(H_Struct)
	STRUCT WMWinHookStruct &H_Struct
	SVAR mafScopeRect=root:maf:mafScopeRect
	if (H_Struct.eventCode == 6 || H_Struct.eventCode == 2)		// i.e. resize or closing -- can't detect dragging
		getwindow mafscopenewer wsize
		mafScopeRect = num2str (v_top) + "," + num2str (v_left) + "," + num2str (v_bottom) + "," + num2str (v_right)	
	endif
	return 0		// i.e. nothing done
End

Function newmafScopeMakeStimProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName, varStr, varName
	Variable varNum
	
	NVAR mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn, mafScopeLastSweepDrtn=root:maf:mafScopeLastSweepDrtn
	NVAR mafScopePulseDrtn=root:maf:mafScopePulseDrtn, mafScopeDoFFT=root:maf:mafScopeDoFFT
	wave mafScopeStimIndicator=root:maf:mafScopeStimIndicator
	wave mafScopeStimWaveD=root:maf:mafScopeStimWaveD
	wave mafScopeShow=root:maf:mafScopeShow, mafScopeLinkedDA=root:maf:mafScopeLinkedDA
	wave mafScopePulseOn = root:maf:mafScopePulseOn, mafScopeTTLOn=root:maf:mafScopeTTLOn
	wave mafScopeStimWave0=root:maf:mafScopeStimWave0
	variable tempval, i, startpt, endpt, actualsrate
	variable TTLOn = mafScopeTTLOn[0] + 2 * mafScopeTTLOn[1] + 4 * mafScopeTTLOn[2] + 8 * mafScopeTTLOn[3]
	string stiminseq, stimoutseq, ch
	
	if (mafScopeSweepDrtn != mafScopeLastSweepDrtn)
		if (mafScopeSweepDrtn == mafScopeLastSweepDrtn + 1)
			mafScopeSweepDrtn = mafScopeLastSweepDrtn * gainscaler (mafScopeLastSweepDrtn, 1)
		elseif (mafScopeSweepDrtn == mafScopeLastSweepDrtn - 1)
			mafScopeSweepDrtn = mafScopeLastSweepDrtn * gainscaler (mafScopeLastSweepDrtn, -1)			
		endif
		mafScopeLastSweepDrtn = mafScopeSweepDrtn
		SetVariable setPulseDrtn win=mafScopeNewer#PTOP,limits={0,1000 * mafScopeSweepDrtn * .8,1000* mafScopeSweepDrtn * .1}
	endif
	stiminseq = ""; stimoutseq = ""
	for (i = 0; i < 8; i += 1)
		ch = num2str (i)
		if (mafScopeShow[i])
			stiminseq += ch
			if (numtype (mafScopeLinkedDA[i]) == 0)
				stimoutseq += num2str (mafScopeLinkedDA[i])
			endif
		endif
	endfor
	if (TTLOn)
		stimoutseq += "D"
	endif
	tempval = max (strlen (stimoutseq), strlen (stiminseq))
	actualsrate = round (mafscopesweepdrtn / numpnts (mafScopeStimWave0) / tempval * 1e6) / 1e6 * tempval
	if (!cmpstr (ctrlName, "SweepDrtn"))		// i.e. was this function called because the sweep duration changed?
		// yes, so fix bottom axis and stim waves
		SetScale/P x 0,actualsrate, "s", root:maf:mafScopeStimWave0, root:maf:mafScopeStimWave1, root:maf:mafScopeStimWave2, root:maf:mafScopeStimWave3, root:maf:mafScopeStimWaveD
		setaxis /z bottom 0, (mafScopeDoFFT ? (1/mafScopeSweepDrtn * 256) : mafScopeSweepDrtn)
	endif
	if (mafscopepulsedrtn > .8 * mafscopesweepdrtn * 1000)
		mafscopepulsedrtn = .8 * mafscopesweepdrtn * 1000
	endif

	// update bar indicating stimulus timing
	SetScale/I x mafscopesweepdrtn *.1, mafscopesweepdrtn * .1 + mafscopepulsedrtn/1000,selectstring (mafScopeDoFFT, "s", "Hz"), mafScopeStimIndicator
	mafscopestimindicator = strlen (stimoutseq) > 0 ? 0 : nan

	// build individual stimulation waves
	startpt = x2pnt (mafScopeStimWave0, .1 * mafscopesweepdrtn)
	endpt = startpt + x2pnt (mafScopeStimWave0, mafScopePulseDrtn/1000) - 1
	for (i = 0; i < 8; i += 1)
		ch = num2str (i)
		if (mafScopeShow[i] && numtype (mafScopeLinkedDA[i]) == 0)	// i.e. AD channel has associated DA
			wave thisstimwave=$("root:maf:mafscopestimwave" + num2str (mafScopeLinkedDA[i]))
			tempval = mafITC_GetHP(mafScopeLinkedDA[i])
			thisstimwave = tempval
			if (mafScopePulseOn[i] && mafScopePulseDrtn > 0)		// i.e. stimulation is wanted for this channel
				tempval = newmafScopePulseAmp (mafScopeLinkedDA[i])
				thisstimwave[startpt, endpt] += tempval
			endif
			tempval = mafITC_DAGain (mafScopeLinkedDA[i]) * 3.2		// 3.2 = 32768 pnts / 10240 mV
			thisstimwave *= tempval
		endif
	endfor
	mafscopestimwaveD = 0
	if (TTLOn)
		if (mafScopePulseDrtn > 0)
			mafScopeStimWaveD[startpt, endpt] = TTLOn
		endif
	endif
	
	// now weave separate stimulation waves together into main wave
	tempval = max (strlen (stiminseq), strlen (stimoutseq))
	make /o/n=(tempval * numpnts (mafScopeStimWave0)) root:maf:mafScopeStimWave
	wave mafScopeStimWave=root:maf:mafScopeStimWave
	SetScale/P x 0,actualsrate/tempval, "s", mafScopeStimWave
	for (i = 0; i < strlen (stimoutseq); i += 1)
		wave w=$("root:maf:mafscopestimwave" + stimoutseq[i])
		mafScopeStimWave[i, ; tempval] = w[(p - i) / tempval]
	endfor
	for ( ; i < strlen (stiminseq); i += 1)	// pad out rest with TTL if needed
		mafScopeStimWave[i, ; tempval] = mafscopeStimWaveD[(p - i) / tempval]		
	endfor
End
function newmafScopePulseAmp (ch)
	variable ch
	wave pulseamp = $("root:maf:mafscopepulseamp" + selectstring (mafitc_isCC(ch),  "VC", "CC" ))
	return (pulseamp[ch])
end

Function newmafScopeHPButtons(ctrlName) : ButtonControl
	String ctrlName
	variable channel, temphp
	
	channel = str2num (ctrlname[strlen (ctrlname) - 1])
	if (!cmpstr (ctrlName[0,4], "IncHP"))
		temphp = +10
	elseif (!cmpstr (ctrlName[0,4], "DecHP"))
		temphp = -10
	endif
	mafITC_SetHP (channel, mafITC_GetHP (channel) + temphp)
	newmafScopeMakeStimProc("",0,"","")
end

Function newmafScopeHPField (ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName, varStr, varName
	Variable varNum
	variable channel, temphp
	
	channel = str2num (ctrlname[strlen (ctrlname) - 1])
	mafITC_SetHP (channel, varNum)
	newmafScopeMakeStimProc("",0,"","")
end

function newmafScopeDoSweep ()
	wave mafScopeStimWave=root:maf:mafScopeStimWave
	NVAR mafScopePulseDrtn=root:maf:mafScopePulseDrtn, mafScopeSweepDrtn=root:maf:mafScopeSweepDrtn
	SVAR mafScopeClip=root:maf:mafScopeClip
	NVAR mafScopeRAvgIndex=root:maf:mafScopeRAvgIndex, mafScopeRAvgNum=root:maf:mafScopeRAvgNum
	NVAR mafScopeDoFFT=root:maf:mafScopeDoFFT
	wave mafScopeLinkedDA=root:maf:mafScopeLinkedDA, mafscopepulseon=root:maf:mafscopepulseon
	wave mafScopeGain=root:maf:mafscopegain, mafScopeShow=root:maf:mafScopeShow
	wave mafScopeCenter=root:maf:mafScopeCenter, mafScopeTTLOn=root:maf:mafScopeTTLOn
	variable numch, tempval, baseline, i, startpt, endpt, woffset
	string stiminseq="", stimoutseq="", istr, ch
	variable TTLOn=mafScopeTTLOn[0] + 2 * mafScopeTTLOn[1] + 4 * mafScopeTTLOn[2] + 8 * mafScopeTTLOn[3]
	mafScopeClip = ""

	// figure out what is being sent out and what is being collected
	for (i = 0; i < 8; i += 1)
		if (mafScopeShow[i])
			stiminseq += num2str (i)
			if (numtype (mafScopeLinkedDA[i]) == 0)
				stimoutseq += num2str (mafScopeLinkedDA[i])
			endif
		endif
	endfor
	if (TTLOn)
		stimoutseq += "D"
	endif
	make /o/n=(numpnts (mafScopeStimWave)) root:maf:mafScopeWave
	wave mafScopeWave=root:maf:mafScopeWave
	if (strlen (stiminseq) < strlen (stimoutseq))
		stiminseq = padstring (stiminseq, strlen (stimoutseq), char2num ("D"))
	elseif (strlen (stimoutseq) < strlen (stiminseq))
		stimoutseq = padstring (stimoutseq, strlen (stiminseq), char2num ("D"))
	endif 
	// run a single sweep
	if (mafITC_isITC18 ())
		execute "ITC18seq \"" + stimoutseq + "\" , \"" + stiminseq + "\""		// calls for ITC18
		execute "ITC18StimAndSample root:maf:mafScopeStimWave, root:maf:mafScopeWave, " + num2str (deltax(mafScopeStimWave) * .8e6) + ", 2, 0"
	else
		execute "ITC16seq \"" + stimoutseq + "\" , \"" + stiminseq + "\""		// calls for ITC16
		execute "ITC16StimAndSample mafScopeStimWave, mafScopeWave, " + num2str (deltax(mafScopeStimWave) * 1e6) + ", 2"
	endif
	//break up result wave
	numch = strlen(stiminseq)
	startpt = x2pnt (mafScopeStimWave, .1 * mafscopesweepdrtn) / numch
	endpt = startpt + x2pnt (mafScopeStimWave, mafScopePulseDrtn/1000) / numch - 1
	for (i = 0; i < 8; i += 1)	// process result waves
		istr = num2str (i)
		SVAR RStr=$("root:maf:mafScopeRStr" + istr)
		if (mafScopeShow[i])		
			tempval = mafITC_ADGain (i) * 3.2		// 3.2 = 32768 pnts / 10240 mV
			woffset = strsearch(stiminseq, istr, 0)
			if (mafScopeDoFFT)
				make /o/n=(numpnts (mafscopewave) / numch) root:maf:wtemp
				WAVE wtemp=root:maf:wtemp
				setscale /p x, 0, deltax (mafscopestimwave) * numch, "s", wtemp
				setscale d, 0, 0, mafITC_Units (i), wtemp
				wtemp = mafscopewave[p * numch + woffset] / tempval		
				FFT /Z /MAG /DEST=$("root:maf:mafScopeWave" + istr) wtemp
				RStr = ""
			else
				make /o/n=(numpnts (mafscopewave) / numch) $("root:maf:mafScopeWave" + istr)
				WAVE w=$("root:maf:mafScopeWave" + istr)
				setscale /p x, 0, deltax (mafscopestimwave) * numch, "s", w
				setscale d, 0, 0, mafITC_Units (i), w
				w = mafscopewave[p * numch + woffset] / tempval		
				baseline = pmean (w, 0, startpt - 1)
				// update running avg of seal resistance
				if ((mafScopePulseOn[i] && newmafScopePulseAmp(i) != 0 && mafScopePulseDrtn > 0))
					if (mafITC_IsCC(i))
						tempval = 1e9 * (pmean (w, endpt - 5, endpt) - baseline) / newmafScopePulseAmp(i)
					else
						tempval = 1e9 * newmafScopePulseAmp(i) / (pmean (w, endpt - 5, endpt) - baseline)
					endif
					wave RAvg=$("root:maf:mafScopeRAvg" + istr)
					RAvg[mafScopeRAvgIndex]=tempval
					mafScopeRAvgIndex = mod (mafScopeRAvgIndex + 1, mafScopeRAvgNum)
					RStr = mafnum2str (mean (RAvg, 0, mafScopeRAvgNum - 1), 2, 1) + "Ohm"
				else
					RStr = ""
				endif
				if (mafScopeCenter[i])
					newmafScopeFixAxis (i) //w -= baseline
				else
					if (baseline < -100/mafscopegain[i])
						mafScopeClip = "Low"
					elseif (baseline > 100/mafscopegain[i])
						mafScopeClip = "High"
					endif
				endif
			endif
		else
			RStr = ""
		endif
	endfor
	return 0
end

Function newmafScopeGoStopProc(ctrlName) : ButtonControl
	String ctrlName
	NVAR mafScopeGoing=root:maf:mafScopeGoing
	NVAR mafScopeSweepInterval=root:maf:mafScopeSweepInterval
	wave mafScopeShow=root:maf:mafScopeShow

	if (sum (mafScopeShow) == 0 || mafScopeGoing)
		CtrlBackground stop
		Button GoStopButton title="Go", win=mafScopeNewer#PTOP
		mafScopeGoing = 0
	else
		Button GoStopButton title="Stop", win=mafScopeNewer#PTOP
		SetBackground newmafScopeDoSweep()
		CtrlBackground start, period=(mafScopeSweepInterval*60)
		mafScopeGoing = 1
	endif
End
Function newmafScopeUpdateInterval(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName, varStr, varName
	Variable varNum
	NVAR mafScopeGoing=root:maf:mafScopeGoing
	if (mafScopeGoing)
		newmafScopeGoStopProc ("")	// call once to turn off
		newmafScopeGoStopProc ("")	// call again to turn back on
	endif
End
